/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.curseofpandora.content.sets.evil;

import com.tterrag.registrate.util.entry.RegistryEntry;
import dev.xkmc.curseofpandora.content.complex.AttrAdder;
import dev.xkmc.curseofpandora.content.complex.BaseTickingToken;
import dev.xkmc.curseofpandora.content.complex.IAttackListenerToken;
import dev.xkmc.curseofpandora.content.complex.ITokenProviderItem;
import dev.xkmc.curseofpandora.content.effect.EmptyEffect;
import dev.xkmc.curseofpandora.event.ClientSpellText;
import dev.xkmc.curseofpandora.init.data.CoPConfig;
import dev.xkmc.curseofpandora.init.data.CoPLangData;
import dev.xkmc.curseofpandora.init.registrate.CoPAttrs;
import dev.xkmc.curseofpandora.init.registrate.CoPEffects;
import dev.xkmc.l2damagetracker.init.L2DamageTracker;
import dev.xkmc.l2serial.serialization.SerialClass;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class EvilSpiritAwakening
extends ITokenProviderItem<Data> {
    private static int getIndexReq() {
        return (Integer)CoPConfig.COMMON.evil.evilSpiritAwakeningRealityIndex.get();
    }

    private static double prot() {
        return (Double)CoPConfig.COMMON.evil.evilSpiritAwakeningReduction.get();
    }

    private static double magic() {
        return (Double)CoPConfig.COMMON.evil.evilSpiritAwakeningMagicBonus.get();
    }

    private static int getDuration() {
        return (Integer)CoPConfig.COMMON.evil.evilSpiritAwakeningDuration.get();
    }

    private static int getMaxLevel() {
        return (Integer)CoPConfig.COMMON.evil.evilSpiritAwakeningMaxLevel.get();
    }

    public EvilSpiritAwakening(Item.Properties properties) {
        super(properties, Data::new);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        boolean pass = ClientSpellText.getReality(level) >= EvilSpiritAwakening.getIndexReq();
        list.add((Component)CoPLangData.IDS.REALITY_INDEX.get(EvilSpiritAwakening.getIndexReq()).m_130940_(pass ? ChatFormatting.YELLOW : ChatFormatting.GRAY));
        list.add((Component)CoPLangData.Evil.AWAKENING.get((int)Math.round(EvilSpiritAwakening.magic() * 100.0), (int)Math.round(EvilSpiritAwakening.prot() * 100.0), (int)Math.round((double)EvilSpiritAwakening.getDuration() / 20.0), EvilSpiritAwakening.getMaxLevel()).m_130940_(pass ? ChatFormatting.DARK_AQUA : ChatFormatting.DARK_GRAY));
    }

    @Override
    public void tick(Player player) {
        if (player.m_21133_((Attribute)CoPAttrs.REALITY.get()) >= (double)EvilSpiritAwakening.getIndexReq()) {
            super.tick(player);
        }
    }

    @SerialClass
    public static class Data
    extends BaseTickingToken
    implements IAttackListenerToken {
        @SerialClass.SerialField
        public ArrayList<Long> list = new ArrayList();
        private boolean updated;

        private static AttrAdder magicAttr(int size) {
            return AttrAdder.of("evil_spirit_awakening", () -> ((RegistryEntry)L2DamageTracker.MAGIC_FACTOR).get(), AttributeModifier.Operation.ADDITION, EvilSpiritAwakening.magic() * (double)size);
        }

        private static AttrAdder protAttr(int size) {
            return AttrAdder.of("evil_spirit_awakening", () -> ((RegistryEntry)L2DamageTracker.REDUCTION).get(), AttributeModifier.Operation.MULTIPLY_TOTAL, -EvilSpiritAwakening.prot() * (double)size);
        }

        @Override
        protected void removeImpl(Player player) {
            Data.magicAttr(this.list.size()).removeImpl(player);
            Data.protAttr(this.list.size()).removeImpl(player);
            player.m_21195_((MobEffect)CoPEffects.AWAKENING.get());
        }

        @Override
        protected void tickImpl(Player player) {
            if (player.m_9236_().m_5776_()) {
                return;
            }
            EmptyEffect eff = (EmptyEffect)((Object)CoPEffects.AWAKENING.get());
            if (this.list.isEmpty()) {
                if (player.m_21023_((MobEffect)eff)) {
                    player.m_21195_((MobEffect)eff);
                }
                Data.magicAttr(this.list.size()).removeImpl(player);
                Data.protAttr(this.list.size()).removeImpl(player);
                return;
            }
            long start = player.m_9236_().m_46467_() - (long)EvilSpiritAwakening.getDuration();
            if (this.list.get(0) < start) {
                this.list.remove(0);
            }
            while (this.list.size() > 5) {
                this.list.remove(0);
            }
            Data.magicAttr(this.list.size()).tickImpl(player);
            Data.protAttr(this.list.size()).tickImpl(player);
            MobEffectInstance ins = player.m_21124_((MobEffect)eff);
            int lv = ins == null ? 0 : ins.m_19564_() + 1;
            int level = Math.min(EvilSpiritAwakening.getMaxLevel(), this.list.size());
            if (this.updated || lv != level) {
                if (player.m_21023_((MobEffect)eff)) {
                    player.m_21195_((MobEffect)eff);
                }
                if (!this.list.isEmpty()) {
                    player.m_7292_(new MobEffectInstance((MobEffect)eff, (int)(this.list.get(0) - start), level - 1));
                }
                this.updated = false;
            }
        }

        public void trigger(Player player) {
            this.updated = true;
            this.list.add(player.m_9236_().m_46467_());
        }
    }
}

